#!/usr/bin/wish
#
# SkateFtp Copyright (c) Gregory Engel 1999
# You may use this file under the terms of the GNU 
# General Public license. 
# This file uses the ftplib by Steffan Traeger
# Copyright (c) 1996-1999 Steffan Traeger
# see ftplib.tcl for details
# Traduit en Français par Fabien (novembre 2025)

package require Tk
# package require FTP 1.2 (replaced by 'source ftp_lib.tcl' line)
package require Tix
source ftp_lib.tcl

############Sets up screen#############

proc startUp {} {
puts "\n\n---------------------------------"
puts "SkateFtp by Gregory Engel (c) 1999 "
puts "this program may be used under  "
puts "the terms of the GNU General    "
puts "Public Liscence. Thanks to      "
puts "Steffan Traeger for the ftp lib "
puts "Translated in French by Fabien "
puts "See www.tcltk.fr               "
puts "---------------------------------\n\n"
global statusField remoteList fileList fileNames server \
       username password home localText remoteText currentLocal\
       localTree localDir remoteFiles details remoteSelected \
       isDirectory isConnected dmode localSelected currentRemote \
       startDir anonPass settings port
image create photo iftp -file "./pics/icon.gif"
wm title . "SkateFtp"
wm iconphoto . -default iftp
wm geometry . 750x600+100+50
if [catch {open ftp.ini r} fileId] {
    puts stderr "Ne peut ouvrir ftp.ini"    
} else {
    set settings [split [read $fileId] \n]         
    }
close $fileId
set startDir [lindex $settings 0]
set anonPass [lindex $settings 1]
#set server "sunsite.unc.edu"     
#set password "rengel1@nycap.rr.com"
#set username "anonymous"
set home [pwd]
set details 0
  
#####Menu#############################
    
menu .menubar -relief raised
. config -menu .menubar 
foreach m {Fichier Vue Connexion } {
    set $m [menu .menubar.m$m -tearoff 0]
    .menubar add cascade -label $m -underline 0 -menu .menubar.m$m
}
$Fichier add command -label "Télécharger vers local"  -command downloadFile
$Fichier add command -label "Téléverser sur serveur" -command uploadFile
$Fichier add command -label "Supprimer en local" -command deleteFileLocal
$Fichier add command -label "Supprimer en distant" -command deleteFileRemote
$Fichier add separator
$Fichier add command -label Quit -command exit
$Connexion add command -label "Ouvrir" -command connect
$Connexion add command -label "Déconnexion" -command disconnect
$Vue add command -label "Details" -command updateDetails
$Vue add separator
$Vue add command -label "Préferences" -command showPrefs
.menubar add cascade -label "?" -underline 0 -menu .menubar.help
menu .menubar.help -tearoff 0
.menubar.help add command -label "A propos de..." -command showAbout
set Menubar .menubar
    
#####Frame for toolbar##################
    
frame .toolbar -borderwidth 1 -relief raised  
pack .toolbar -side top -fill x -padx 2
    
###Toolbar Buttons#####################
    
button .toolbar.quit -image [image create photo -file "./pics/door02.gif"] \
     -command exit -relief groove
button .toolbar.disconnect -image [image create photo -file "./pics/trash.gif"] \
    -command disconnect -relief groove
button .toolbar.connect -image [image create photo -file "./pics/checkit.gif"] \
    -command connect  -relief groove
pack .toolbar.connect .toolbar.disconnect -side left
pack .toolbar.quit -side right
button .toolbar.spacer -text "" -width 10 -relief flat
.toolbar.spacer configure -state disabled
pack .toolbar.spacer -side left
################mode radio buttons###########
radiobutton .toolbar.binary -variable dmode -text "Binaire" -value "Binary"
pack .toolbar.binary -side left
radiobutton .toolbar.ascii -variable dmode -text "Chaine ASCII" -value "ASCII"
pack .toolbar.ascii -side left
set dmode "Binary"
###############toolbars for each pane#######
###local
frame .direcTb -borderwidth 1 -relief flat
pack .direcTb -side top -fill x -expand 1
frame .direcTb.local -borderwidth 1 -relief raised
pack .direcTb.local -side left -padx 2 -fill both
button .direcTb.local.delete -image \
      [image create photo -file "$home/pics/delete.gif"] \
      -command deleteFileLocal -relief groove
pack .direcTb.local.delete -side left
button .direcTb.local.mkdir -image [image create photo -file "$home/pics/mkdir.gif"] \
      -command "getName doItInDaHouse" -relief groove
pack .direcTb.local.mkdir -side left
button .direcTb.local.rmdir -image [image create photo -file "$home/pics/rmdir.gif"] \
      -command deleteFileLocal -relief groove
pack .direcTb.local.rmdir -side left
button .direcTb.local.upload -image [image create photo -file "./pics/up.gif"] \
    -command uploadFile -relief groove
pack .direcTb.local.upload -side left
button .direcTb.local.spacer -relief flat -width 7
.direcTb.local.spacer configure -state disabled
pack .direcTb.local.spacer -side left

###remote

frame .direcTb.remote -borderwidth 1 -relief raised 
pack .direcTb.remote -side left -fill both -padx 2 -expand 1
button .direcTb.remote.download -image [image create photo -file "./pics/down.gif"] \
    -command downloadFile -relief groove
pack .direcTb.remote.download -side left
button .direcTb.remote.delete -image \
      [image create photo -file "$home/pics/delete.gif"] \
      -command deleteFileRemote -relief groove
pack .direcTb.remote.delete -side left
button .direcTb.remote.mkdir -image [image create photo -file "$home/pics/mkdir.gif"] \
      -command "getName doItToIt" -relief groove
pack .direcTb.remote.mkdir -side left
button .direcTb.remote.rmdir -image [image create photo -file "$home/pics/rmdir.gif"] \
      -command rmDirRemote -relief groove
pack .direcTb.remote.rmdir -side left
button .direcTb.remote.refresh -image [image create photo -file "$home/pics/refresh.gif"] \
      -command refreshRemote -relief groove
pack .direcTb.remote.refresh -side left
#####Bind balloon help to the buttons######
    
tixBalloon .balloon 
.balloon bind .toolbar.quit -balloonmsg "Quitter"
.balloon bind .direcTb.local.delete -balloonmsg "Supprimer fichier local"
.balloon bind .direcTb.remote.delete -balloonmsg "Supprimer fichier distant"
.balloon bind .direcTb.local.mkdir -balloonmsg "Crée un répertoire local"
.balloon bind .direcTb.remote.mkdir -balloonmsg "Crée un répertoire distant"
.balloon bind .direcTb.local.rmdir -balloonmsg "Supprimer un répertoire local"
.balloon bind .direcTb.remote.rmdir -balloonmsg "Supprimer un répertoire distant"
.balloon bind .toolbar.disconnect -balloonmsg "Deconnexion"
.balloon bind .toolbar.connect -balloonmsg "Connexion"
.balloon bind .direcTb.local.upload -balloonmsg "Téléverser"
.balloon bind .direcTb.remote.download -balloonmsg "Télécharger" 
.balloon bind .direcTb.remote.refresh -balloonmsg "Rafraîchir"
##############textfields for each pane######
    
frame .direcFrame   
pack .direcFrame -side top -fill y -expand 1 
frame .direcFrame.local -borderwidth 1 -relief raised
pack .direcFrame.local -side left -padx 2 -pady 2 -fill both -expand 1
set localText .direcFrame.local.current
entry $localText -width 23 -textvariable currentLocal 
bind $localText <Return> localDirChanged
pack $localText -side left -padx 1 -pady 1 -fill x -expand 1
frame .direcFrame.remote -borderwidth 1 -relief raised -width 20
pack .direcFrame.remote -side left -padx 2 -pady 2 -fill both
set remoteText .direcFrame.remote.current
entry $remoteText -width 200 -textvariable currentRemote
bind $remoteText <Return> remoteDirChanged
pack $remoteText -side left -padx 1 -pady 1 -fill x -expand 1  
#####SplitPane###############################
    
tixPanedWindow .pane1
pack .pane1 -side top -expand 1 -fill both -padx 1 -pady 1
set topPane [.pane1 add topPane -min 100 -size 400 ] 
set bottomPane [.pane1 add bottomPane ] 
tixPanedWindow $topPane.pane -orientation horizontal
pack $topPane.pane -side top -expand 1 -fill both
set localPane [$topPane.pane add localPane -size 200]
set remotePane [$topPane.pane add remotePane -size 500]
    
#####Add Status Field##########################

text $bottomPane.status -width 300 -height 100 -background black \
   -foreground cyan -relief raised -yscrollcommand "$bottomPane.sb set" \
   -wrap word
$bottomPane.status tag configure error -foreground yellow    
scrollbar $bottomPane.sb -orient vert -command "$bottomPane.status yview" \
          -repeatinterval 100
grid $bottomPane.status $bottomPane.sb -sticky news
grid rowconfigure $bottomPane 0 -weight 1
grid $bottomPane.sb  
grid $bottomPane.status 
set statusField $bottomPane.status  
    
########Add remote tlist#########################
 
tixScrolledTList $remotePane.dirlist -options {
tlist.orient horizontal
tlist.selectMode single 
#tlist.width 60
#tlist.height 25
    } 
set tlist [$remotePane.dirlist subwidget tlist]
set remoteFiles $remotePane.dirlist
$tlist configure -command processRemoteDblClick -browsecmd "remoteBrowse $remoteFiles" 
set remoteList $tlist    
#bind $remoteList <Double-1> {processClick}
pack $remotePane.dirlist -side left -fill both -expand 1 -padx 1 -pady 1
    
######Add TreeView###############################

tixTree $localPane.tree  -options {
	hlist.separator "/"
	#hlist.width 35
	#hlist.height 25
    }

pack $localPane.tree -expand yes -fill both -padx 1 -pady 1 -side left
set hlist [$localPane.tree subwidget hlist]
$localPane.tree config \
                       -opencmd "OpenDir $localPane.tree"  \
                       -closecmd "updateLocal $localPane.tree" \
                       -browsecmd "localBrowse $localPane.tree" 
set localTree $localPane.tree    
###### Add the root directory to the tree#########
set image [image create photo -file "./pics/Folder.gif"]    
AddDirec $localPane.tree /
OpenDir $localPane.tree /
set currentLocal $startDir
localDirChanged
set isDirectory 1 
set fileList ""
set isConnected 0
set port 21
}
#############END OF STARTUP#################################
proc refreshRemote {} {
    global isConnected
    if {$isConnected} {
    emptyList
    getList
    }
}
##############Track local selected file#####################
proc localBrowse {w selec} {
    global localSelected 
    set localSelected $selec
}
###maintains the name of the currently selected remote file
proc remoteBrowse {w dir} {
    global remoteSelected fileList isDirectory
    if {$dir != 0} {
    set name [lindex $fileList [expr $dir - 1]]
    if {[string index $name 0] == "d"} {
    set isDirectory 1
    set remoteSelected [breakFileName $name]
    } else {
        set isDirectory 0
        set remoteSelected [breakFileName $name]
    }        
    } else {
        set isDirectory 1
        set remoteSelected ".."
    }
}
########process click on view-details menu###################
proc updateDetails {} {
    global details
    if {! $details} {
        set details 1
        emptyList
        getList
    } else {
        set details 0
        emptyList
        getList
    }
}
###to get filename from extended info returned by FTP::List##
proc breakFileName {name} {
       set nameList [split $name " "]
       set fileName [lindex $nameList [expr [llength $nameList]-1]]
       #######for 2 word filenames
       set last [lindex $nameList [expr [llength $nameList]-2]]
       if {![string match {[0-9>]} [string index $last [expr [string length $last]-1]]]} {
                set fileName [append last " $fileName"]            
              } 
        return $fileName     
}
##########process user entries to the local text box########
proc localDirChanged {} {
    global localTree currentLocal localText
    set name [$localText get]
    set name [string trim $name]
    if {[string index $name [expr [string length $name]-1]]== "/"} {
        set name [string trimright $name "/"]
    }
    if {$name != ""} { 
       if {[glob -nocomplain $name/*]!= {}} { 
        set list [split $name /]
        set current [lindex $list 0]
        set currentLocal $current   
       for {set i 0} {$i <= [llength $list]} {incr i 1} {
        OpenDir $localTree "$current"
           if {$i > 0} {
               append current "/[lindex $list $i]"
           }       
       }
      } 
     }    
}    
#######process user entries in remote text box#########

proc remoteDirChanged {} {
    global remoteText currentRemote
    set name [$remoteText get]
    if {[FTP::Cd $name]} {
        set currentRemote $name 
        emptyList
        getList       
    } else {
        $remoteText delete 0 end
        $remoteText insert end [FTP::Pwd]
        if {[$remoteText get] != "/"} {
            $remoteText insert end "/"
        }        
    }
}

#######Updates the current local dir when tree colapses
proc updateLocal {tree selec} {
    global localText
    set currentLocal $selec
    $localText delete 0 end 
    $localText insert end $currentLocal     
    set hlist [$tree subwidget hlist]
    foreach kid [$hlist info children $selec] {
	    $hlist hide entry $kid
    }
}

##############process double clicks on remote pane#########
proc processRemoteDblClick {event} {
    global fileList fileNames remoteList 
    set index [expr [tixEvent value] -1]
    set name [lindex $fileList $index]
    #set nameList [split $name " "]
    if {$index == -1} {
        set name "ddd"
        set fileName ".."
    } else {
        set fileName [breakFileName $name]
        }    
    if {[string index $name 0]== "d" \
        || [string index $name 0]== "l"} {
        if {[FTP::Cd "$fileName" ]} {
        emptyList
        getList
        }
    } else {
        
    }  
}

#############used to add directory to treeview (from tix demo)

proc AddDirec {tree dir} {
    global home 
    set hlist [$tree subwidget hlist]
    if {$dir == "/"} {
	set text /
    } else {
	set text [file tail $dir]
    }
    set pic [image create photo -file "$home/pics/Folder.gif"]
    $hlist add $dir -itemtype imagetext \
	     -text $text -image $pic

    catch {
	# We need a catch here because the directory may not be readable by us
	#
	$tree setmode $dir none
	if {[glob -nocomplain $dir/*] != {}} {
	    $tree setmode $dir open
	}
    }
}

#############Open directory in tree(from tix demo)##############

proc OpenDir {tree dir} {
    global home localText currentLocal
    set PWD [pwd]
    set hlist [$tree subwidget hlist]
    if {[$hlist info children $dir] != {}} {
	# We have already loaded this directory. Let's just
	# show all the child entries
	#
	# Note: since we load the directory only once, it will not be
	#       refreshed if the you add or remove files from this
	#	directory.
	#
	foreach kid [$hlist info children $dir] {       
	    $hlist show entry $kid
     $localText delete 0 end
     $localText insert end $dir 
	}
	return
    }

    if [catch {cd $dir}] {
	# We can't read that directory, better not do anything
	cd $PWD
	return
    }
    set currentLocal $dir
    $localText delete 0 end
    $localText insert end $dir
    set files [lsort [glob -nocomplain *]]
    foreach f $files {
	if [file isdirectory $f] {
	    if {$dir == "/"} {
		set subdir /$f
	    } else {
		set subdir $dir/$f
	    }
	    AddDirec $tree $subdir
	} else {
	    if {$dir == "/"} {
		set file /$f
	    } else {
		set file $dir/$f
	    }

	    $hlist add $file -itemtype imagetext \
		-text $f -image [image create photo -file "$home/pics/Document.gif"]
	}
    }
    
    cd $PWD
}

###########################################################

proc downloadFile {} {
    global remoteSelected isDirectory currentLocal localTree home isConnected
    if {$isConnected} {
    if {[file writable $currentLocal]} {
    if {! $isDirectory} {
    FTP::Type binary
    set fileSize [FTP::FileSize $remoteSelected]
    ProgressBar init 0 $fileSize $remoteSelected
    FTP::Get $remoteSelected "$currentLocal/$remoteSelected"
    ProgressBar done
    set hlist [$localTree subwidget hlist]
    $hlist add "$currentLocal/$remoteSelected" -itemtype imagetext \
		-text $remoteSelected -image [image create photo -file "$home/pics/Document.gif"]
    foreach kid [$hlist info children $currentLocal] {
	    $hlist show entry $kid
    } 
    }
    } else {
        tk_messageBox  -message "You don't have write permission in the \
                             local directory $currentLocal." -type ok
    }     
    }    
}

###########################################################

proc uploadFile {} {
    global localSelected isConnected
    if {$isConnected} {
    if {![file isdirectory $localSelected]} {
        set fileSize [file size $localSelected]
        FTP::Type binary
        ProgressBar init 0 $fileSize $localSelected
        if {![FTP::Put $localSelected [file tail $localSelected]]} {
           tk_messageBox  -message "Error uploading $localSelected" -type ok 
        } else {
            ProgressBar done
           # emptyList
           # getList
        }
    }
    }    
}
###############delete local file###########################
proc deleteFileLocal {} {
    global localSelected localTree
    file delete -force $localSelected
    set hlist [$localTree subwidget hlist]    
    $hlist hide entry $localSelected
    $hlist delete entry $localSelected
}
##############delete a remote file#########################

proc deleteFileRemote {} {
    global remoteSelected isDirectory isConnected
    if {$isConnected} {
    if {! $isDirectory} {
    if {[FTP::Delete $remoteSelected]} {
        emptyList
        getList
    } else {
       tk_messageBox -message "Error removing $remoteSelected" -type ok 
    }
    }
    }    
}
############remove remote directory#########################
proc rmDirRemote {} {
    global remoteSelected isDirectory isConnected
    if {$isConnected} {
    if {$isDirectory} {
        set files [FTP::NList ./$remoteSelected]
        for {set i 0} {$i < [llength $files]} {incr i 1} {
            FTP::Delete "./[lindex $files $i]"
        }
        if {[FTP::RmDir $remoteSelected]} {
            emptyList
            getList
        } else {
           tk_messageBox -message "Error removing $remoteSelected" -type ok 
        }
    }
    }    
}
###########make dirctory local##########################################
proc doItInDaHouse {entry w} {
    global localTree currentLocal home
    set name [$entry get]
    destroy $w
    file mkdir "$currentLocal/$name"
    set hlist [$localTree subwidget hlist]
    $hlist add "$currentLocal/$name" -itemtype imagetext \
		-text $name -image [image create photo -file "$home/pics/Folder.gif"]
    foreach kid [$hlist info children $currentLocal] {
	    $hlist show entry $kid
    }
    
}
###########get remote directory name from user##########################
proc getName {command} {
      
        set w .enter
        toplevel $w -bd 0 
		wm transient $w .
		wm title $w "Make Remote Directory"
		wm resizable $w 0 0
		focus $w
        frame $w.frame -bd 4
	  	pack $w.frame -side top -fill both
		label $w.frame.label -text "Enter Directory Name" -relief flat -anchor w -bd 1
	  	pack $w.frame.label -in $w.frame -side top -fill x -padx 10 -pady 5
        entry $w.frame.entry -width 30 
	  	pack $w.frame.entry -in $w.frame -side left -padx 10 -pady 5
        set entryField $w.frame.entry
        bind $entryField <Return> "$command $entryField $w"
        set x [expr [winfo x .] + ([winfo width .] / 2) - ([winfo reqwidth $w] / 2)]
		set y [expr [winfo y .] + ([winfo height .] / 2) - ([winfo reqheight $w] / 2)]
        wm geometry $w +$x+$y
       
      }
     
###########make the directory############################################
proc doItToIt {entry w} {
            global isConnected
            if {$isConnected} {
            set name [$entry get]
            destroy $w
            if {[FTP::MkDir $name ]} {
                emptyList
                getList
            } else {
                tk_messageBox -message "Error making directory $name" -type ok
            }
            }       
}
          
#############################################################

proc showAbout {} {
    tk_messageBox -title "A propos de skateFtp" -message "skateFtp par Gregory Engel\n créé en 1999,\n traduit par Fabien en 2025 \n Plus d'infos sur www.tcltk.fr" -type ok    
}

###############connect########################################
proc connect {} {
    source "ConnectDlg.tcl"
}

proc doConnect {} {
    global server username password statusField remoteList isConnected    
 for {set i 0} {$i < 10} {incr i 1} {
     if {$isConnected} {
           disconnect
       }
     if [FTP::Open $server  $username $password -progress {ProgressBar update}] {
       if {[llength $remoteList] > 0 } {
        emptyList
       }
       set isConnected 1
       getList
       set i 10
       wm title . "SkateFtp---$server"
  } else {
      $statusField insert end "Attempt [expr $i + 1] failed\n"
      $statusField insert end "Trying again.....\n" 
      after 1000      
  }
 }
      
}

#############disconnect#######################################

proc disconnect {} {    
    global server
    FTP::Close   
    emptyList
    wm title . "SkateFtp Déconnecté"
    set isConnected 0
    puts "\nDéconnecté du serveur $server"
    puts "Merci d'avoir utilisé SkateFtp\n\n"
}

###############empty remote list###########################

proc emptyList {} {
    global remoteList fileList remoteText
    if {[llength $remoteList] > 0} {
    for {set i 0} {$i <= [llength $fileList]} {incr i 1} {
        $remoteList delete $i
    }
    }
    $remoteText delete 0 end
}

##############get file list##################################

proc getList {} {
 global fileList server statusField remoteText
 set fileList [FTP::List]
 $remoteText delete 0 end 
 $remoteText insert end "[FTP::Pwd]"
 if {[$remoteText get] != "/"} {
     $remoteText insert end "/"
 }
 setList $fileList
 $statusField insert end "Connecté au serveur $server\n"
 $statusField see end
}
################set up list entries###########################

proc setList {l} {    
    global remoteList home details
    set image [image create photo -file "$home/pics/Up.gif"]
       $remoteList insert end -itemtype imagetext \
          -text ".. \(cd Up\)" -image $image 
       for {set i 0} {$i < [llength $l]} {incr i 1} {          
            set name [lindex $l $i]
            if {$details != 1} {
             set fileName [breakFileName $name]
             } else {
              set fileName $name
             }   
            set pic [setImage $name]
            $remoteList insert end -itemtype imagetext \
                     -text $fileName -image $pic
           }         
}

################set image for list entries################

proc setImage {name} { 
    global home   
    if { [string index $name 0] == "d" } {
           set image [image create photo -file "$home/pics/Folder.gif"]          
         } elseif {[string match *.gif $name ] \
                   || [string match *.jpg $name] \
                   || [string match *.bmp $name] \
                   || [string match *.xpm $name] \
                   || [string match *.png $name] } {
                  set image [image create photo -file "$home/pics/Palette.gif"]                                    
         } elseif {[string match *.zip $name] \
                   || [string match *.tar.gz $name] \
                   || [string match *.tgz $name]  
                   || [string match *.gz $name]
                   || [string match *.Z $name]
                   || [string match *.tar.bz $name]
                   || [string match *.bz $name]
                   || [string match *.bz2 $name]
                   || [string match *.lsm $name]} {
                  set image [image create photo -file "$home/pics/Box.gif"]                  
         } elseif {[string index $name 0] == "l"} {
                  set image [image create photo -file "$home/pics/Link.gif"]                  
         } elseif {[string match *.exe $name] } {
                  set image [image create photo -file "$home/pics/Workstation.gif"]
         } elseif {[string match *.rpm $name] } {
                  set image [image create photo -file "$home/pics/redhat.gif"]
         } else {
                  set image [image create photo -file "$home/pics/Document.gif"]                  
         }
   return $image 
}

####### overwrite default ftp_lib display message procedure
####### this is from the ftpdemo.tcl file#################

namespace eval FTP {
proc DisplayMsg {msg {state ""}} {
global test statusField 
	$statusField configure -state normal
	
	# change state from "error" to "" for procedure test_9notfound
	if { ($state == "error") && [info exist test(proc)] && ($test(proc) == "test_99notfound") } {
		set state ""
    }
    if {![string match "*PASS*" $msg]} {
      
      # header	{$statusField insert end "$msg\n" header}
     # default 	{$statusField insert end "$msg\n"}   
     #  data		{$statusField insert end "[string range $msg 2 end]\n" data} 
	switch $state {        
    	 error		{$statusField insert end "$msg\n" error}
	  control	{$statusField insert end "[string range $msg 2 end]\n" control}     
    }  
	}
	#$statusField configure -state disabled
	$statusField see end
	update idletasks
}}
##############progress bar for transfers###################
proc ProgressBar {state {bytes 0} {total {}} {filename {}}} {
global progress
    	set w .progress
	switch $state {
	  init	{
		set progress(percent) "0%"
		set progress(total) $total
		set progress(left) 0
 		toplevel $w -bd 0 -class Progressbar
		wm transient $w .
		wm title $w Progress
        	wm iconname $w Progress
		wm resizable $w 0 0
		focus $w
		
		frame $w.frame -bd 4
	  	  pack $w.frame -side top -fill both
		label $w.frame.label -text "Transfert de $filename..." -relief flat -anchor w -bd 1
	  	  pack $w.frame.label -in $w.frame -side top -fill x -padx 10 -pady 5
          		frame $w.frame.bar -bd 1 -relief sunken -bg #ffffff 
	  	  pack $w.frame.bar -in $w.frame -side left -padx 10 -pady 5
		frame $w.frame.bar.dummy -bd 0 -width 250 -height 0
	  	  pack $w.frame.bar.dummy -in $w.frame.bar -side top -fill x
		frame $w.frame.bar.pbar -bd 0 -width 0 -height 20
	  	  pack $w.frame.bar.pbar -in $w.frame.bar -side left
		label $w.frame.proz -textvariable progress(percent) -width 5 -relief flat -anchor e -bd 1
	  	  pack $w.frame.proz -in $w.frame -side right -padx 10 -pady 5

		wm withdraw $w
		update idletasks
		set x [expr [winfo x .] + ([winfo width .] / 2) - ([winfo reqwidth $w] / 2)]
		set y [expr [winfo y .] + ([winfo height .] / 2) - ([winfo reqheight $w] / 2)]
		wm geometry $w +$x+$y
		update idletasks
		wm deiconify $w
		update idletasks
 	  }

	  update {
 		if {![winfo exist $w]} {return}  
		set cur_width 250
		catch {
			set progress(percent) "[expr round($bytes) * 100 / $progress(total)]%";
			set cur_width [expr round($bytes * 250 / $progress(total))]
		} msg
		$w.frame.bar.pbar configure -width $cur_width -bg #76d9f5
		update idletasks
	  }

	  done 	{
	  	unset progress
		destroy $w
		update
	  }
	}
}
##########Show prefs dialog#############################
proc showPrefs {} {
    global anonPass startDir
    source "PrefDlg.tcl"
}

#######call start up to start app##########################

startUp
bind . <Destroy> exit

##############end of script##################################





