#!/usr/bin/tixwish

proc showPrefDlg {} {
    global startDir anonPass
    set w .pref
    toplevel $w -bd 0
    wm title $w Preferences 
	wm resizable $w 0 0
	focus $w
    label $w.startDirLabel -text "Starting Local Directory"
    grid $w.startDirLabel -sticky sw -padx 10 -pady 4 
    frame $w.f1
    entry $w.f1.startEntry -width 25 -textvariable startDir
    button $w.f1.browseButton -text "Browse" -command "browseButtonPressed $w"
    pack $w.f1.startEntry -side left 
    pack $w.f1.browseButton -side top
    grid $w.f1 -sticky nw -padx 10 -pady 5
    label $w.anonPassLabel -text "Anonymous Password (email address)"
    grid $w.anonPassLabel -sticky sw -padx 10 
    entry $w.anonPassEntry -width 34 -textvariable anonPass
    grid $w.anonPassEntry -sticky nw -padx 10 -pady 5
    frame $w.f2 -borderwidth 2 -relief ridge
    frame $w.f3 -borderwidth 2 -relief raised
    button $w.f3.spacerLeft -width 7 -state disabled -relief flat
    button $w.f3.applyButton -text Apply -command \
              "applyButtonPressed $w.f1.startEntry $w.anonPassEntry $w" \
               -relief groove
    button $w.f3.cancelButton -text Cancel -command "cancelButtonPressed $w" -relief groove
    button $w.f3.spacerRight -width 7 -state disabled -relief flat
    pack $w.f3.spacerLeft $w.f3.applyButton $w.f3.cancelButton \
            $w.f3.spacerRight -side left -pady 3
    grid $w.f3 -sticky sw -pady 3
    set x [expr [winfo x .] + ([winfo width .] / 2) - ([winfo reqwidth $w] / 2)]
    set y [expr [winfo y .] + ([winfo height .] / 2) - ([winfo reqheight $w] / 2)]
    set x [expr $x - 50]
    set y [expr $y - 100]
    wm geometry $w +$x+$y    
}
proc browseButtonPressed {w} {
	tixDirSelectDialog $w.dialog   
    $w.dialog config -command selectDir
    $w.dialog popup
}
proc selectDir {dir} {
    global startDir
    set startDir $dir
}
proc applyButtonPressed {start anon w} {
    global startDir anonPass settings
    set startDir [$start get]
    set anonPass [$anon get]
    set settings [lreplace $settings 0 0 $startDir]
    set settings [lreplace $settings 1 1 $anonPass]
    set fileId [ open ftp.ini w+ ] 
    for {set i 0} {$i < [llength $settings]} {incr i 1} {
        set line [lindex $settings $i]
        puts $fileId $line
    }
    close $fileId 
    destroy $w
    
}
proc cancelButtonPressed {w} {
    destroy $w
}


showPrefDlg
