#!/usr/bin/tixwish

proc showConnect {} {
    global settings profile savepass anonymous port dmode server\
           password username
    set w .connect
    toplevel $w -bd 0
    wm title $w "Configuration de la connexion" 
	wm resizable $w 0 0
	focus .
    tixComboBox $w.combo -label "Nom de la connexion :" -editable false -dropdown true \
     -command "setSelection" \
     -variable profile -editable true
    getvalues $w.combo
    grid $w.combo -sticky w -padx 39 -pady 10
    frame $w.f3 -borderwidth 1 -relief raised
    label $w.f3.addressLabel -text "Serveur ftp :" 
    entry $w.f3.addressEntry -textvariable server -width 30 
    grid $w.f3.addressLabel $w.f3.addressEntry -sticky w -pady 10
    label $w.f3.idLabel -text "Nom utilisateur" 
    entry $w.f3.idEntry  -textvariable username -width 30
    grid $w.f3.idLabel $w.f3.idEntry  -pady 10
    label $w.f3.passwordLabel -text "Mot de passe" 
    entry $w.f3.passwordEntry -width 30 -textvariable password -show * 
    grid $w.f3.passwordLabel $w.f3.passwordEntry -sticky w -pady 10
    grid $w.f3 -sticky nw -padx 10 -pady 2 -padx 10
    frame $w.f2 -borderwidth 2 -relief ridge
    label $w.f2.portLabel -text "Port" 
    entry $w.f2.portEntry -width 5 -textvariable port
    label $w.f2.portLabel2 -text "Port distant ( en général 21 )"
    pack $w.f2.portLabel -side left -padx 18 
    pack $w.f2.portEntry -side left
    pack $w.f2.portLabel2 -side left -padx 8 
    grid $w.f2 -sticky w -padx 20 -pady 5 -padx 10
    frame $w.checkframe -borderwidth 2 -relief sunken
    checkbutton $w.checkframe.anonymous -text "Anonyme" -variable anonymous \
                 -command anonPressed
    checkbutton $w.checkframe.savepw -text "Enregistrer le mot de passe" -variable savepass
    pack $w.checkframe.anonymous -side left -padx 20 -pady 5
    pack $w.checkframe.savepw -side top -padx 20 -pady 5
    grid $w.checkframe -padx 10 -pady 5
    frame $w.radioframe -borderwidth 2 -relief sunken
    radiobutton $w.radioframe.binary -variable dmode -text "Binaire" -value "Binary"
    radiobutton $w.radioframe.ascii -variable dmode -text "Chaine ASCII" -value "ASCII"
    button $w.radioframe.spacerRight -width 1 -relief flat -state disabled
    pack $w.radioframe.binary -side left -padx 20 -pady 5 
    pack $w.radioframe.ascii -side left -padx 48 -pady 5
    pack $w.radioframe.spacerRight
    grid $w.radioframe -padx 10 -pady 5
    frame $w.buttonbar -borderwidth 1 -relief raised 
    button $w.buttonbar.ok -text "OK" -relief groove -command \
           "okPressed $w.f3.addressEntry $w.f3.idEntry $w.f3.passwordEntry \
            $w.f2.portEntry $w"
    button $w.buttonbar.cancel -text "Annuler" -relief groove -command "cancelPressed $w"
    button $w.buttonbar.save -text "Enregistrer" -relief groove -command "savePressed $w.combo"
    button $w.buttonbar.new -text "nouveau" -relief groove -command newPressed
    button $w.buttonbar.remove -text "Distant" -relief groove \
               -command "removePressed $w.combo"
    pack  $w.buttonbar.ok $w.buttonbar.save $w.buttonbar.remove \
          $w.buttonbar.new $w.buttonbar.cancel \
           -side left -pady 3 -padx 1
    grid $w.buttonbar -pady 3
    set x [expr [winfo x .] + ([winfo width .] / 2) - ([winfo reqwidth $w] / 2)]
    set y [expr [winfo y .] + ([winfo height .] / 2) - ([winfo reqheight $w] / 2)]
    set x [expr $x - 50]
    set y [expr $y - 100]
    wm geometry $w +$x+$y  
    set profile ""
    set server ""
    set port 21
    set dmode "Binary"
    set password ""
    set username ""
    set savepass 1
    set anonymous 0
    
}
proc getvalues {combo} {
    global settings
    for {set i 0} {$i < [llength $settings]} {incr i 1} {
        set line [lindex $settings $i]
        if {[string match >* $line] } {
            $combo insert end [string trimleft $line > ]
        }
    }
}
proc setSelection {w} {
    global settings profile server port dmode password username \
             anonPass savepass anonymous
    for {set i 0} {$i < [llength $settings]} {incr i 1} {
        if {[string trimleft [lindex $settings $i] >] == $profile} {
            set i [expr {$i + 1}]
            set server [lindex $settings $i]
            set i [expr {$i + 1}]
            set username [lindex $settings $i]
            set i [expr {$i + 1}]
            set password [lindex $settings $i]
            set i [expr {$i + 1}]
            set port [lindex $settings $i]
            set i [expr {$i + 1}]
            set dmode [lindex $settings $i]
            if {[string compare $password {nosave}] == 0} {
                set savepass 0
            } else {
                set savepass 1
            }
            if {![string compare "$anonPass" "$password"]} {
                set anonymous 1
            } else {
                set anonymous 0
            }
            
        }
    }
}
proc okPressed {address id pass portset w} {
    global password username server isConnected 
    set server [$address get]
    set username [$id get]
    set password [$pass get]
    set port [$portset get]
    destroy $w
    if {$server !=""} {
    doConnect
    }    
}
proc cancelPressed {w} {
    destroy $w
}
proc savePressed {combo} {
    global profile server port dmode password username \
           settings home savepass
    set found 0
    for {set i 0} {$i <[llength $settings]} {incr i 1} {
     if {[lindex $settings $i] == ">$profile"} {
         set found 1
         set i [expr $i+1]
         set settings [lreplace $settings $i $i $server]
         set i [expr $i+1]
         set settings [lreplace $settings $i $i $username]
         set i [expr $i+1]
         if {!$savepass} {
         set password "nosave"
         } 
         set settings [lreplace $settings $i $i $password]
         set i [expr $i+1]
         set settings [lreplace $settings $i $i $port]
         set i [expr $i+1]
         set settings [linsert $settings end $dmode]
         
     }
    }
    if {!$found} {   
    set settings [linsert $settings end ">$profile"] 
    set settings [linsert $settings end $server]   
    set settings [linsert $settings end $username ]
    if {!$savepass} {
        set password "nosave"
    }
    set settings [linsert $settings end $password] 
    set settings [linsert $settings end $port] 
    set settings [linsert $settings end $dmode]
    $combo insert end $profile
    }   
    set fileId [ open ftp.ini w+ ] 
    for {set i 0} {$i < [llength $settings]} {incr i 1} {
        set line [lindex $settings $i]
        if {$line != ""} {
        puts $fileId $line
        }    
    }
    close $fileId  
    
}
proc newPressed {} {
    global profile server port dmode password username \
              savepass anonymous
    set profile ""
    set server ""
    set port 21
    set dmode "Binary"
    set password ""
    set username ""
    set savepass 1
    set anonymous 0
    
}
proc removePressed {combo} {
    global settings profile
    puts [llength $settings]
    for {set i 0} {$i < [llength $settings]} {incr i 1} {
        if {[string match [lindex $settings $i] ">$profile" ]} {
            set settings [lreplace $settings $i [expr $i + 5] ]            
            }                    
        }
    set fileId [ open ftp.ini w+ ] 
    for {set i 0 } {$i < [llength $settings]} {incr i 1} {
        set line [lindex $settings $i]
        if {$line != ""} {
        puts $fileId $line
        }
    }
    close $fileId    
    newPressed
    set listbox [$combo subwidget listbox]
    $listbox delete 0 end
    getvalues $combo
    puts [llength $settings]
       
}
proc anonPressed {} {
    global anonPass anonymous password username port savepass
    if {$anonymous == 1} {
        set password $anonPass
        set username "anonymous"
        set port 21
        set savepass 1
    }
}

showConnect

