set tcl_traceExec 0

namespace eval textsh {

variable pipe ""
variable piperun 0
variable w ""

proc readch {} {
variable piperun 
variable pipe
variable w

if {$piperun} {
	set s [read $pipe]

	if {$s!=""} {
		$w insert end $s
		$w see end
		tkTextSetCursor $w end
		update
		}
	if { [eof $pipe]} {
		set piperun 0
		textsh::startsh
		}
	after 150 "textsh::readch"
	}
}

proc pressed {ch c} {
variable pipe
variable piperun
variable cmds
variable w

#puts stdout $c

if {$piperun} {  
		 
	switch $c {
	BackSpace {
		set cmds [string range $cmds 1 [expr [string length $cmds] -1 ]]
		}
	Return {

		textsh::runcmd $cmds
		}
                default {
		set cmds $cmds$ch
		tkTextSetCursor $w end
		$w see end
         	}
	}
}
}

proc runcmd {cmd args} {
variable pipe
variable cmds
variable w
c


set argstring ""
for {set i 0} {$i <[string length $args]} {incr i } {
set c [string index $args $i]
if {($c!="\173") && ($c!="\175")} {
set argstring "$argstring$c"
}
}


set cmds ""

switch $cmd {
	clear   {
		$w delete 0.0 end
		$w see end
		runcmd ""	
		}
	exit	{
		$w insert end "\ntextsh: unsupported command"
		}

	default {
		puts $pipe "$cmd $argstring"
		flush $pipe
		}
	}

}

proc startsh {} {
variable pipe
variable piperun
variable cmds
variable w

set cmds ""

if {!$piperun} {
	set piperun 1

	set pipe [open "|sh -c {exec sh 2>&1 }" "RDWR"]
	#set pipe [open "|sh 2>&1" "RDWR"]

	fconfigure $pipe -blocking 0
	textsh::readch
	runcmd ""
	}
}

proc start {win} {
variable w
set w $win
bind $w <KeyPress> "textsh::pressed %A %K"
#bind $w <KeyRelease> "tkTextSetCursor %W end"
startsh
}

proc stop {} {
variable pipe
variable piperun

set piperun 0
close $pipe
}

}

#text .cmd  -foreground black -insertbackground orange  -insertborderwidth 0 -insertwidth 6 
#pack .cmd -expand 1 -fill both
#button .b -text "Stop" -command "textsh::stop"
#button .b2 -text "Start" -command "textsh::start .cmd"
#pack .b .b2 -side left


