namespace eval  specc {

namespace export specc

proc enter {w p} {
set tag "t$p"
$w.l config -text [format "Dec: %d Hex: %x  Oct: %o" $p $p $p]
$w.c itemconfigure $tag -fill [$w.c cget -background]
$w.c itemconfigure "r$p" -fill  [$w.c cget -highlightcolor] -outline [$w.c cget -highlightcolor]
}

proc leave {w p} {
$w.c itemconfigure "t$p" -fill [$w.c cget -highlightcolor]
$w.c itemconfigure "r$p" -fill [$w.c cget -background] -outline [$w.c cget -background]
}

proc place_text {win p} {
macro::rec specc::place_text $win $p
$win insert insert "[format {%c} $p]"
}

proc specc {args} {
c
global result1 c
set result1 "<None>"
set w .wdlgc


if {[set i [lsearch -exact $args "-font"]] >= 0} {
	set default [lindex $args [expr $i+1]]
} else { set font $c(font-editor) }

if {[set i [lsearch -exact $args "-win"]] >= 0} {
	set win [lindex $args [expr $i+1]]
} else { set win ""}


set font "[lindex $font 0] $c(specc-fontsize) [lindex $font 2] [lindex $font 3] [lindex $font 4] [lindex $font 5] [lindex $font 6]"
set cellsize [lindex [font metrics $font] 5]

catch {destroy $w}
toplevel $w

wm title $w "Select special char"
wm resizable $w false false
wm transient $w .

if {$win==""} {
	wm protocol  $w WM_DELETE_WINDOW "set result1 <None>" 
}

canvas  $w.c -width [expr $cellsize*16] -height [expr $cellsize*16] -borderwidth 1 -relief raised -background  $c(color-listbg) -relief sunken -highlightcolor $c(color-listtext)
label $w.l 
set p 0
set co [$w.c cget -background]

for {set y 0} {$y <16 } {incr y } {
	for {set x 0} {$x <16 } {incr x } {
		set xx [expr $x*$cellsize+5]
		set yy  [expr $y*$cellsize+2]
		$w.c create rectangle $xx $yy [expr "$xx+$cellsize"] [expr "$yy+$cellsize"] -fill $co -outline $co -tag "r$p"
		$w.c create text  $xx $yy   -text [string range  [format "%c" $p] 0 1] -font $font -anchor nw -tag "t$p" -fill $c(color-listtext)

		$w.c bind "r$p" <Motion>  "specc::enter $w $p"
		$w.c bind "r$p" <Enter>   "specc::enter $w $p"
		$w.c bind "r$p" <Leave>  "specc::leave $w $p"

		$w.c bind "t$p" <Motion>  "specc::enter $w $p"
		$w.c bind "t$p" <Enter>   "specc::enter $w $p"
		$w.c bind "t$p" <Leave>  "specc::leave $w $p"

		if {$win==""} {
			$w.c bind "t$p" <Button-1>  "set result1 $p"
			$w.c bind "r$p" <Button-1>  "set result1 $p"
		} else { 
			$w.c bind "t$p" <Button-1>  "specc::place_text $win $p"
			$w.c bind "r$p" <Button-1>  "specc::place_text $win $p"
		}


		incr p
	}
}

grid $w.c -column 0 -row 0
grid $w.l

if {$win==""} {
	vwait result1
	destroy $w
	return $result1
}

}

}



