#?-Macros
#?
#? Tcltextedit has the ability to record and play macros.
#? Macros are by default stored in $HOME/.tcltextedit/???.mac
#? where ??? stands for the name of the macro.
#? The macro files are plain tcl scripts, that makes it possible
#? for any person with knowledge of tcl to customize your own macros.
#?
#? %2Recording:%
#? You record macros by selecting the menu: Macro->Record Macro.
#? When recording is activatef text appear in the status line telling
#? you that the recording mode is active.
#? 
#? The just use the editor as usual and all your actions will be recorded.
#? 
#? To stop recording shoose: Macro->Stop recording, and a prompt will
#? appear asking you to shoose a name for your macro.
#? When you hit the Ok button your macro will be stored.
#?
#? Related topics: %lSPEEDBUTTONS% %lMACRO_MANAGER% %lMACRO_EDITING%
#? 
#?-Macro_Manager
#?
#? The macro manager is a dialog that will help you to manage your macro
#? files.
#?
#? You can use it to edit/delete/rename and make new macro files.
#?
#? Related topics: %lMACROS% %lMACRO_EDITING%
#?
#?-Macro_Editing
#?
#? There are currently two ways to create macro files from within the 
#? text editor.
#? 
#? %2 1. Record macro%
#?
#? %2 2. Create macro files with the% %lMACRO_MANAGER% 
#?
#? There are also two different types of macros.
#?
#? %2 1. Tk/Tcl macro files.%
#?     This type is automatically created when a macro is recorded.
#?
#? %2 2. Shell macro files.%
#?     This type of macro files must be created from the %lMACRO_MANAGER%
#?     
#?     These files must contain "#!/bin/sh" as the first line, otherwise
#?     the texteditor won't recognise it as a shell macro.
#?
#?     When a shell macro is executed it will either be executed in the
#?     background, or if the TextShell window is open, it will be executed there. 
#?
#?     All shell macro files are executed with commandline parameters
#?     accesible with $0...	
#?
#?     The commandline parameters are:
#?
#?     $0	- The path to the executed macro file. (Controlled by sh)	
#?     $1	- The path and name combined, of the currently open file.
#?     $2	- The name of the currently open file.
#?     $3	- The path of the currently open file.
#?     $4	- The filename without the last .
#?
#? Related topics: %lMACROS% %lMACRO_MANAGER%

namespace eval macro {

namespace export rec play new buttonconf update names files manager realnames

proc realnames {} {
global home installdir
set k [glob -nocomplain "$home/*.mac"]
set n $k
set k [glob -nocomplain "$installdir/*.mac"]
set n "$n $k"
return $n
}

proc names {} {
set n ""
foreach k [macro::realnames] {
set n "$n {[file rootname [file tail $k]]}" 
}
return $n
}

proc update {} {
global c home

.menu.macromenu delete 0 end
.menu.macromenu add command -label "Record macro" -underline 0 -accelerator "($c(key-newmacro))" -command macro::new
.menu.macromenu add command -label "Macro manager" -underline 7 -accelerator "($c(key-macromgr))" -command macro::manager
.menu.macromenu add separator

set k [macro::names]

foreach n $k {
.menu.macromenu add command -label $n -command "macro::play {$n}"
}

}

proc stop {} {
global macro_rec
set macro_rec 0
 .menu.macromenu entryconfigure [.menu.macromenu index "Stop recording"] -label "Record macro"
 .status.filler config -text ""
}

proc new {} {
global macro_data macro_rec cu_macro

if {!$macro_rec} {
 .menu.macromenu entryconfigure [.menu.macromenu index "Record macro"] -label "Stop recording"
 set macro_data ""
 set macro_rec 1
 .status.filler config -text "Recording.. (press F5 to stop)"
} else {
 

   switch [ macro::store] {
   ok       {macro::stop
             macro::msave
            }
   abort    {macro::stop}
   continue {}
   }
 
}
}


proc key {data} {
global current_window window

 set window($current_window,echange) 1
 set window($current_window,change) 1
 win::update

 switch $data  {
 Return	{.text insert insert "\n"}
 Alt_L 	{}
 Alt_R 	{}
 Shift_L    {}
 Shift_R   {}
 Alt_L       {}
 Control_L {}
 Control_R {}
 Caps_Lock {}
 Home      {tkTextSetCursor .text {insert linestart} }
 End       {tkTextSetCursor .text {insert lineend} }
 Mode_switch {}
 Delete    { txt::cut .text }
 BackSpace { txt::backspace .text }
 space     {.text insert insert " "}
 Right     { tkTextSetCursor .text  "insert + 1 chars"}
 Left      { tkTextSetCursor .text  "insert - 1 chars"}
 Up        { tkTextSetCursor .text  "insert - 1 lines"}
 Down      { tkTextSetCursor .text  "insert + 1 lines"}

 default   {   .text insert insert $data }
  }

.text see insert   

}

proc rec { cmd args } {
global macro_data macro_rec

if {$macro_rec} {

if {$args=="\r"} {set args "Return"}
if {$args=="\n"} {set args "Return"}
if {$args=="\b"} {set args "BackSpace"}
if {$args=="\x7f"} {set args "Delete"}

set macro_data "$macro_data$cmd $args\n"
c $cmd $args
}

}


proc msave {} {
global env macro_data home current_macro prgname
set n $current_macro
file delete -force "$home/$n.mac"
set f [open "$home/$n.mac" "CREAT WRONLY" ]

puts $f "###################################################"
puts $f "# Macro recorded by $prgname"
puts $f "###################################################\n"

puts $f $macro_data nonewline
close $f
macro::update
speed::Update
}

proc play {n} {
global c window current_window

set last_macro $n
macro::rec macro::play $n

c $n

set file [macro::get_path $n]
if {[macro::get_type $n]=="sh"} {
	c "Macro type SH"
	exec "chmod" "774" "$file"
	if {$c(textshell)} { 
	
		set p1 $window($current_window,name)
		set l  [file split $p1]
		set p2 [lindex $l [expr [llength $l] -1]]
		set p3 [file dirname $p1]
		set p4 [file rootname $p2]
		textsh::runcmd $file "$p1 $p2 $p3 $p4"
		 
		} else { exec "$file" }
	} else {
	c "Macro type TCL $file"
	source $file
	}
}

proc get_path {n} {
global home installdir
c $n
if {[file exists "$home/$n.mac"]==1} { 
	return "$home/$n.mac"
	} else {
		if {[file exists "$installdir/$n.mac"]==1} {
			return "$installdir/$n.mac"
			}
	}
return ""
}

proc get_type {n} {
set file [macro::get_path $n]
if {$file!=""} {
	set f [open $file r]
	fconfigure $f -blocking 0
	set s [gets $f]
	close $f

	if {[string first "#!/bin/sh" $s]!=-1} { return "sh" } else { return "tktcl" }
	}
return ""
}

proc store {} {
global url current_window window c current_macro r c
set current_macro ""
set ou .ou
catch {destroy $ou}
toplevel $ou
wm title $ou "Save macro as:"
frame $ou.fr1
frame $ou.fr2
pack $ou.fr1 $ou.fr2 -side left
label $ou.fr1.lab -text "Name:"
xentry $ou.fr1.ent -textvariable current_macro
pack $ou.fr1.lab $ou.fr1.ent -side left -pady 10 -padx 10
$ou.fr1.ent selection range 0 end
xbutton $ou.fr2.ok -text "Ok" -width 10 -command "set r ok"
xbutton $ou.fr2.can -text "Abort" -width 10 -command "set r abort"
xbutton $ou.fr2.con -text "Continue.." -width 10 -command "set r continue"

pack $ou.fr2.ok $ou.fr2.con $ou.fr2.can -side top -padx 10 -pady 5
focus $ou.fr1.ent
bind $ou.fr1.ent <Return> "set r ok"
bind $ou.fr1.ent <KP_Enter> "set r ok"
bind $ou.fr1.ent <Escape> "set r continue"
grab $ou
powin $ou

vwait r
destroy $ou
return $r
}                                          

proc edit {n} {
c
macro::rec macro::edit $n
set file [macro::get_path $n]
file::Load "file {$file}" -force
}

proc delete {n} {
macro::rec macro::delete $n
c

set file [macro::get_path $n]
if {$file!=""} {file delete -force "$file"}

macro::update
speed::Update
macro::manager_update
}

proc rename {old new} {
macro::rec macro::rename $old $new
c
set o "[macro::get_path $old]"
set n  "[file join [file dirname $o] $new].mac"
c $o to $n

file rename $o $n

macro::update
speed::Update
macro::manager_update
}



proc create {} {
global home
set info [get_macrotype]

set typ [lindex $info 0]
set name [lindex $info 1]


if {$typ!="cancel"} {
set f [open "$home/$name.mac" "CREAT WRONLY" ]

if {$typ=="sh"} { 
puts $f "#!/bin/sh"
puts $f "#Shell script macro file\n\n"
} else {
puts $f "#TK/Tcl script macro file\n\n"
}
close $f
macro::update
speed::Update
macro::manager_update
file::Load "file {$home/$name.mac}" -force
}

}


#Get macro type dialog
proc get_macrotype {} {
global c
set w .mseltype
catch {destroy $w}
toplevel $w
wm title $w "Select macro type"
global typ r
set typ "tktcl"

radiobutton $w.b1 -text "Tk/Tcl Macro file" -variable typ -value "tktcl"
radiobutton $w.b2 -text "Shell script" -variable typ -value "sh"
xbutton $w.ok -text "Ok" -width 6 -command "set r ok"
xbutton $w.cancel -width 6 -text "Cancel" -command "set r cancel"
label $w.l -text "Macro name:"
entry $w.e -width 30 -background $c(color-editbg) 

grid $w.l -column 0 -row 0 -sticky w
grid $w.e -column 1 -row 0 -sticky w -columnspan 2
grid $w.b1 -column 0 -row 1 -sticky w -columnspan 2
grid $w.b2 -column 2 -row 1 -sticky w
grid $w.ok -column 2 -row 2 -sticky e
grid $w.cancel -column 0 -row 2 -sticky w

powin $w
focus $w.e
vwait r
set typ "$typ {[$w.e get]}"
destroy $w
if {$r=="ok"} { return $typ } else { return $r}
}


proc manager_update {} {
c
if {[winfo exists .mgui.l]} {
	set w .mgui.l
	$w delete 0 end
	foreach n [macro::names] {
		$w insert end "{$n} {[macro::get_type $n]}"
		}
}
}

proc Rename_DLG {s} {
global r  
set ou .ou
catch {destroy $ou}
toplevel $ou
wm title $ou "Rename macro"
set r "cancel"
frame $ou.f
label $ou.f.label -text "Rename $s to:"
xbutton $ou.f.rename -text "Rename" -command "set r rename" -width 5   
xbutton $ou.f.cancel -text "Cancel" -command "set r cancel" -width 5
xentry $ou.f.e
pack $ou.f.label
pack $ou.f.e
pack $ou.f.rename $ou.f.cancel -side left  -padx 10
bind $ou <Escape> "set r cancel"
bind $ou <Return> "set r rename"
pack $ou.f -side left
$ou.f.e insert end $s
powin $ou
focus $ou.f.e
$ou.f.e selection range 0 end
vwait r
set r "$r {[$ou.f.e get]}"
destroy $ou
return $r
}


proc manager {} {
global c
c "Macro manager"
set w .mgui
catch {destroy $w}
toplevel $w
wm title $w "Macro manager"

scrollbar $w.scroll -command "$w.l yview"
mclistbox::mclistbox $w.l -yscrollcommand "$w.scroll set" -width 47  -background $c(color-listbg) -labelbg $c(color-background)
 
frame $w.b
xbutton $w.b.new -text "New"    -width 6 -command "macro::create"
xbutton $w.b.del -text "Delete" -width 6 -command {
set sel [.mgui.l curselection]
if {$sel!=""} { macro::delete "[lindex [macro::names] $sel]" }
}

xbutton $w.b.ren -text "Rename" -width 6 -command {
set sel [.mgui.l curselection]
if {$sel!=""} { 
	set oname "[lindex [macro::names] $sel]"
	set r [macro::Rename_DLG $oname]
	
	if {[lindex $r 0]=="rename"} {
	set nname "[lindex $r 1]"
	macro::rename $oname $nname
	}

	}
}


xbutton $w.b.ed  -text "Edit"   -width 6 -command {
set sel [.mgui.l curselection]
if {$sel!=""} { macro::edit "[lindex [macro::names] $sel]" }

}
 
xbutton $w.ok  -text "Ok"     -width 6 -command "destroy $w"

grid $w.l -column 0 -row 0 -rowspan 10 -sticky nsew
grid $w.scroll -column 1 -row 0 -rowspan 10 -sticky ns
grid $w.b.new -column 0 -row 0 
grid $w.b.del -column 0 -row 1  
grid $w.b.ren -column 0 -row 2  
grid $w.b.ed  -column 0 -row 3                              
grid $w.b -column 2 -row 0 -sticky n
grid $w.ok  -column 2 -row 9 -sticky s
grid columnconfigure $w 0 -weight 1
grid rowconfigure $w 0 -weight 1

$w.l column add macro -label "Macro" -width 40 
$w.l column add type  -label "Type" -width 7

manager_update

bind $w.l <Double-Button-1> {
macro::edit "[lindex [macro::names] [.mgui.l curselection]]"
}

powin $w
}







}